/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.recipe.AbstractRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.RangedItem;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PiglinBarteringRecipe
extends AbstractRecipe<Container> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final Ingredient ingredient;
    private final SimpleWeightedRandomList<RangedItem> weightedResults;

    public PiglinBarteringRecipe(ResourceLocation id, Ingredient ingredient, SimpleWeightedRandomList<RangedItem> weightedResults) {
        super(id);
        this.ingredient = ingredient;
        this.weightedResults = weightedResults;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public SimpleWeightedRandomList<RangedItem> getWeightedResults() {
        return this.weightedResults;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess registryAccess) {
        return this.weightedResults.m_216820_(RANDOM).map(rangedItem -> rangedItem.isRanged() ? new ItemStack((ItemLike)rangedItem.item, Mth.m_216271_((RandomSource)RANDOM, (int)rangedItem.min, (int)rangedItem.max)) : new ItemStack((ItemLike)rangedItem.item, rangedItem.min)).orElse(ItemStack.f_41583_);
    }

    public NonNullList<Ingredient> m_7527_() {
        return (NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), list -> list.add((Object)this.ingredient));
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.PIGLIN_BARTERING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.PIGLIN_BARTERING_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<PiglinBarteringRecipe> {
        public PiglinBarteringRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(serializedRecipe, "ingredient");
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            JsonArray results = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"results");
            results.forEach(result -> {
                RangedItem rangedItem = RangedItem.fromJson(result);
                if (rangedItem != null) {
                    int weight = GsonHelper.m_13824_((JsonObject)GsonHelper.m_13918_((JsonElement)result, (String)"weighted ranged item"), (String)"weight", (int)1);
                    builder.m_146271_((Object)rangedItem, weight);
                }
            });
            return new PiglinBarteringRecipe(recipeId, ingredient, (SimpleWeightedRandomList<RangedItem>)builder.m_146270_());
        }

        @Nullable
        public PiglinBarteringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            int length = buffer.m_130242_();
            for (int i = 0; i < length; ++i) {
                RangedItem rangedItem = RangedItem.fromNetwork(buffer);
                int weight = buffer.m_130242_();
                builder.m_146271_((Object)rangedItem, weight);
            }
            return new PiglinBarteringRecipe(recipeId, ingredient, (SimpleWeightedRandomList<RangedItem>)builder.m_146270_());
        }

        public void toNetwork(FriendlyByteBuf buffer, PiglinBarteringRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            List weightedRangedItems = recipe.getWeightedResults().m_146338_();
            buffer.m_130130_(weightedRangedItems.size());
            weightedRangedItems.forEach(weightedRangedItem -> {
                ((RangedItem)weightedRangedItem.m_146310_()).toNetwork(buffer);
                buffer.m_130130_(weightedRangedItem.m_142631_().m_146281_());
            });
        }
    }
}

